#include "Arduino.h"
#include "QurioFireSensor.h"

QurioFireSensor::QurioFireSensor()
{
  pinMode(A0, INPUT);
  pinMode(A1, INPUT);
  pinMode(A3, INPUT);
  pinMode(A5, INPUT);
  _outpin1 = A2;
  _outpin2 = A4;
  pinMode(_outpin1, OUTPUT);
  pinMode(_outpin2, OUTPUT);

}

int QurioFireSensor::getSensorValue(int inpin)
{
   int val;
   val = digitalRead(inpin);
   return val;
}

float QurioFireSensor::getUsSensorValue(int trigpin,int echopin)
{
   float distance;  
   float duration;

   digitalWrite(trigpin, LOW);
   delayMicroseconds(2);
   digitalWrite(trigpin, HIGH);
   delayMicroseconds(100);
   digitalWrite(trigpin, LOW);
   
   duration = pulseIn(echopin,HIGH);
   distance = duration/58.82;
   return distance;    
}

