#include "Arduino.h"
#include "QurioFireMotor.h"

QurioFireMotor::QurioFireMotor()
{
  pinMode(2, OUTPUT);          
  pinMode(3, OUTPUT);
  pinMode(5, OUTPUT);
  pinMode(4, OUTPUT);
  pinMode(7, OUTPUT);
  pinMode(6, OUTPUT);
  pinMode(8, OUTPUT);          
  pinMode(11, OUTPUT);
  pinMode(9, OUTPUT);          
  pinMode(12, OUTPUT);
  pinMode(13, OUTPUT);
  pinMode(10, OUTPUT);
}

void QurioFireMotor::leftClk(int speed)
{
  digitalWrite(2 , HIGH );
  digitalWrite(3 , LOW );
  analogWrite(5, speed);
}

void QurioFireMotor::leftAclk(int speed)
{
  digitalWrite(2 , LOW );
  digitalWrite(3 , HIGH );
  analogWrite(5, speed);
}

void QurioFireMotor::rightClk(int speed)
{
  digitalWrite(4 , HIGH );
  digitalWrite(7 , LOW );
  analogWrite(6, speed);
}

void QurioFireMotor::rightAclk(int speed)
{
  digitalWrite(4 , LOW );
  digitalWrite(7 , HIGH );
  analogWrite(6, speed);
}

void QurioFireMotor::leftStop()
{
  digitalWrite(2 , LOW );
  digitalWrite(3 , LOW );
  analogWrite(5, 0);
}

void QurioFireMotor::rightStop()
{
  digitalWrite(4 , LOW );
  digitalWrite(7 , LOW );
  analogWrite(6, 0);
}


void QurioFireMotor::forward(int spdl, int spdr)
{
  leftAclk(spdl);
  rightClk(spdr);
}

void QurioFireMotor::reverse(int spdl, int spdr)
{
  leftClk(spdl);
  rightAclk(spdr);
}


void QurioFireMotor::vehStop()
{
 leftStop();
 rightStop();
}


void QurioFireMotor::hardLeftTurn(int spdl,int spdr)
{
  leftClk(spdl);
  rightClk(spdr);
}

void QurioFireMotor::hardRightTurn(int spdl,int spdr)
{
  leftAclk(spdl);
  rightAclk(spdr);
}

void QurioFireMotor::moveM3Clk(int spd)
{
    	digitalWrite(8 , HIGH );
	digitalWrite(11 , LOW );
	analogWrite(9,spd);
  } 
 
void QurioFireMotor::moveM3Aclk(int spd)
{
    	digitalWrite(8 , LOW );
	digitalWrite(11 , HIGH );
	analogWrite(9,spd);
  } 

void QurioFireMotor::moveM4Clk(int spd)
  {
  	digitalWrite(12 , HIGH );
  	digitalWrite(13 , LOW );
	analogWrite(10,spd);
  }
  
void QurioFireMotor::moveM4Aclk(int spd)
  {
  	digitalWrite(12 , LOW );
  	digitalWrite(13 , HIGH );
	analogWrite(10,spd);
  }


void QurioFireMotor::stopM3()
{
   	digitalWrite(8 , LOW );
	digitalWrite(11 , LOW );
	analogWrite(9, 0 );
  } 
  
void QurioFireMotor::stopM4()
  {
  	digitalWrite(12 , LOW );
  	digitalWrite(13 , LOW );
	analogWrite(10, 0 );
  }

